/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.parquet.table.metadata.CodecInfo;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ColumnTypeInfo", generator="Immutables")
@Immutable
final class ImmutableColumnTypeInfo
extends ColumnTypeInfo {
    private final String columnName;
    @Nullable
    private final CodecInfo codec;
    @Nullable
    private final ColumnTypeInfo.SpecialType specialType;

    private ImmutableColumnTypeInfo(Builder builder) {
        this.columnName = builder.columnName;
        this.codec = builder.codec;
        this.specialType = builder.specialType;
    }

    @Override
    @JsonProperty(value="columnName")
    public String columnName() {
        return this.columnName;
    }

    @Override
    @JsonProperty(value="codec")
    public Optional<CodecInfo> codec() {
        return Optional.ofNullable(this.codec);
    }

    @Override
    @JsonProperty(value="specialType")
    public Optional<ColumnTypeInfo.SpecialType> specialType() {
        return Optional.ofNullable(this.specialType);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnTypeInfo && this.equalTo(0, (ImmutableColumnTypeInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableColumnTypeInfo another) {
        return this.columnName.equals(another.columnName) && Objects.equals(this.codec, another.codec) && Objects.equals((Object)this.specialType, (Object)another.specialType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.columnName.hashCode();
        h += (h << 5) + Objects.hashCode(this.codec);
        h += (h << 5) + Objects.hashCode((Object)this.specialType);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ColumnTypeInfo{");
        builder.append("columnName=").append(this.columnName);
        if (this.codec != null) {
            builder.append(", ");
            builder.append("codec=").append(this.codec);
        }
        if (this.specialType != null) {
            builder.append(", ");
            builder.append("specialType=").append((Object)this.specialType);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableColumnTypeInfo fromJson(Json json) {
        Builder builder = ImmutableColumnTypeInfo.builder();
        if (json.columnName != null) {
            builder.columnName(json.columnName);
        }
        if (json.codecIsSet) {
            builder.codec(json.codec);
        }
        if (json.specialTypeIsSet) {
            builder.specialType(json.specialType);
        }
        return builder.build();
    }

    private static ImmutableColumnTypeInfo validate(ImmutableColumnTypeInfo instance) {
        instance.checkColumnName();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ColumnTypeInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ColumnTypeInfo.Builder {
        private static final long INIT_BIT_COLUMN_NAME = 1L;
        private static final long OPT_BIT_CODEC = 1L;
        private static final long OPT_BIT_SPECIAL_TYPE = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String columnName;
        @Nullable
        private CodecInfo codec;
        @Nullable
        private ColumnTypeInfo.SpecialType specialType;

        private Builder() {
        }

        @Override
        @JsonProperty(value="columnName")
        @CanIgnoreReturnValue
        public final Builder columnName(String columnName) {
            Builder.checkNotIsSet(this.columnNameIsSet(), "columnName");
            this.columnName = Objects.requireNonNull(columnName, "columnName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder codec(CodecInfo codec) {
            Builder.checkNotIsSet(this.codecIsSet(), "codec");
            this.codec = Objects.requireNonNull(codec, "codec");
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="codec")
        @CanIgnoreReturnValue
        public final Builder codec(Optional<? extends CodecInfo> codec) {
            Builder.checkNotIsSet(this.codecIsSet(), "codec");
            this.codec = codec.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder specialType(ColumnTypeInfo.SpecialType specialType) {
            Builder.checkNotIsSet(this.specialTypeIsSet(), "specialType");
            this.specialType = Objects.requireNonNull(specialType, "specialType");
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="specialType")
        @CanIgnoreReturnValue
        public final Builder specialType(Optional<? extends ColumnTypeInfo.SpecialType> specialType) {
            Builder.checkNotIsSet(this.specialTypeIsSet(), "specialType");
            this.specialType = specialType.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableColumnTypeInfo build() {
            this.checkRequiredAttributes();
            return ImmutableColumnTypeInfo.validate(new ImmutableColumnTypeInfo(this));
        }

        private boolean codecIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean specialTypeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean columnNameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ColumnTypeInfo is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.columnNameIsSet()) {
                attributes.add("columnName");
            }
            return "Cannot build ColumnTypeInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ColumnTypeInfo", generator="Immutables")
    static final class Json
    extends ColumnTypeInfo {
        @Nullable
        String columnName;
        @Nullable
        Optional<CodecInfo> codec = Optional.empty();
        boolean codecIsSet;
        @Nullable
        Optional<ColumnTypeInfo.SpecialType> specialType = Optional.empty();
        boolean specialTypeIsSet;

        Json() {
        }

        @JsonProperty(value="columnName")
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @JsonProperty(value="codec")
        public void setCodec(Optional<CodecInfo> codec) {
            this.codec = codec;
            this.codecIsSet = true;
        }

        @JsonProperty(value="specialType")
        public void setSpecialType(Optional<ColumnTypeInfo.SpecialType> specialType) {
            this.specialType = specialType;
            this.specialTypeIsSet = true;
        }

        @Override
        public String columnName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CodecInfo> codec() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ColumnTypeInfo.SpecialType> specialType() {
            throw new UnsupportedOperationException();
        }
    }
}

