/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.parquet.table.metadata.DataIndexInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DataIndexInfo", generator="Immutables")
@Immutable
final class ImmutableDataIndexInfo
extends DataIndexInfo {
    private final Set<String> columns;
    private final String indexTablePath;

    private ImmutableDataIndexInfo(Iterable<String> columns, String indexTablePath) {
        this.columns = ImmutableDataIndexInfo.createUnmodifiableSet(ImmutableDataIndexInfo.createSafeList(columns, true, false));
        this.indexTablePath = Objects.requireNonNull(indexTablePath, "indexTablePath");
    }

    @Override
    @JsonProperty(value="columns")
    public Set<String> columns() {
        return this.columns;
    }

    @Override
    @JsonProperty(value="indexTablePath")
    public String indexTablePath() {
        return this.indexTablePath;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDataIndexInfo && this.equalTo(0, (ImmutableDataIndexInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableDataIndexInfo another) {
        return this.columns.equals(another.columns) && this.indexTablePath.equals(another.indexTablePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.columns.hashCode();
        h += (h << 5) + this.indexTablePath.hashCode();
        return h;
    }

    public String toString() {
        return "DataIndexInfo{columns=" + this.columns + ", indexTablePath=" + this.indexTablePath + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDataIndexInfo fromJson(Json json) {
        ImmutableDataIndexInfo instance = ImmutableDataIndexInfo.of(json.columns, json.indexTablePath);
        return instance;
    }

    public static ImmutableDataIndexInfo of(Set<String> columns, String indexTablePath) {
        return ImmutableDataIndexInfo.of(columns, indexTablePath);
    }

    public static ImmutableDataIndexInfo of(Iterable<String> columns, String indexTablePath) {
        return ImmutableDataIndexInfo.validate(new ImmutableDataIndexInfo(columns, indexTablePath));
    }

    private static ImmutableDataIndexInfo validate(ImmutableDataIndexInfo instance) {
        instance.checkIndexTablePath();
        instance.checkColumns();
        return instance;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DataIndexInfo", generator="Immutables")
    static final class Json
    extends DataIndexInfo {
        @Nullable
        Set<String> columns = Collections.emptySet();
        @Nullable
        String indexTablePath;

        Json() {
        }

        @JsonProperty(value="columns")
        public void setColumns(Set<String> columns) {
            this.columns = columns;
        }

        @JsonProperty(value="indexTablePath")
        public void setIndexTablePath(String indexTablePath) {
            this.indexTablePath = indexTablePath;
        }

        @Override
        public Set<String> columns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String indexTablePath() {
            throw new UnsupportedOperationException();
        }
    }
}

