/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.metadata.DataIndexInfo;
import io.deephaven.parquet.table.metadata.GroupingColumnInfo;
import io.deephaven.parquet.table.metadata.SortColumnInfo;
import io.deephaven.parquet.table.metadata.TableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TableInfo", generator="Immutables")
@Immutable
final class ImmutableTableInfo
extends TableInfo {
    private final String version;
    private final List<GroupingColumnInfo> groupingColumns;
    private final List<DataIndexInfo> dataIndexes;
    private final List<ColumnTypeInfo> columnTypes;
    private final List<SortColumnInfo> sortingColumns;

    private ImmutableTableInfo(Builder builder) {
        this.groupingColumns = ImmutableTableInfo.createUnmodifiableList(true, builder.groupingColumns);
        this.dataIndexes = ImmutableTableInfo.createUnmodifiableList(true, builder.dataIndexes);
        this.columnTypes = ImmutableTableInfo.createUnmodifiableList(true, builder.columnTypes);
        this.sortingColumns = ImmutableTableInfo.createUnmodifiableList(true, builder.sortingColumns);
        this.version = builder.versionIsSet() ? builder.version : Objects.requireNonNull(super.version(), "version");
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="groupingColumns")
    public List<GroupingColumnInfo> groupingColumns() {
        return this.groupingColumns;
    }

    @Override
    @JsonProperty(value="dataIndexes")
    public List<DataIndexInfo> dataIndexes() {
        return this.dataIndexes;
    }

    @Override
    @JsonProperty(value="columnTypes")
    public List<ColumnTypeInfo> columnTypes() {
        return this.columnTypes;
    }

    @Override
    @JsonProperty(value="sortingColumns")
    public List<SortColumnInfo> sortingColumns() {
        return this.sortingColumns;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableInfo && this.equalTo(0, (ImmutableTableInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableTableInfo another) {
        return this.version.equals(another.version) && this.groupingColumns.equals(another.groupingColumns) && this.dataIndexes.equals(another.dataIndexes) && this.columnTypes.equals(another.columnTypes) && this.sortingColumns.equals(another.sortingColumns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.groupingColumns.hashCode();
        h += (h << 5) + this.dataIndexes.hashCode();
        h += (h << 5) + this.columnTypes.hashCode();
        h += (h << 5) + this.sortingColumns.hashCode();
        return h;
    }

    public String toString() {
        return "TableInfo{version=" + this.version + ", groupingColumns=" + this.groupingColumns + ", dataIndexes=" + this.dataIndexes + ", columnTypes=" + this.columnTypes + ", sortingColumns=" + this.sortingColumns + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTableInfo fromJson(Json json) {
        Builder builder = ImmutableTableInfo.builder();
        if (json.versionIsSet) {
            builder.version(json.version);
        }
        if (json.groupingColumns != null) {
            builder.addAllGroupingColumns(json.groupingColumns);
        }
        if (json.dataIndexes != null) {
            builder.addAllDataIndexes(json.dataIndexes);
        }
        if (json.columnTypes != null) {
            builder.addAllColumnTypes(json.columnTypes);
        }
        if (json.sortingColumns != null) {
            builder.addAllSortingColumns(json.sortingColumns);
        }
        return builder.build();
    }

    private static ImmutableTableInfo validate(ImmutableTableInfo instance) {
        instance.checkVersion();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TableInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TableInfo.Builder {
        private static final long OPT_BIT_VERSION = 1L;
        private long optBits;
        @Nullable
        private String version;
        private final List<GroupingColumnInfo> groupingColumns = new ArrayList<GroupingColumnInfo>();
        private final List<DataIndexInfo> dataIndexes = new ArrayList<DataIndexInfo>();
        private final List<ColumnTypeInfo> columnTypes = new ArrayList<ColumnTypeInfo>();
        private final List<SortColumnInfo> sortingColumns = new ArrayList<SortColumnInfo>();

        private Builder() {
        }

        @Override
        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(String version) {
            Builder.checkNotIsSet(this.versionIsSet(), "version");
            this.version = Objects.requireNonNull(version, "version");
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addGroupingColumns(GroupingColumnInfo element) {
            this.groupingColumns.add(Objects.requireNonNull(element, "groupingColumns element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addGroupingColumns(GroupingColumnInfo ... elements) {
            for (GroupingColumnInfo element : elements) {
                this.groupingColumns.add(Objects.requireNonNull(element, "groupingColumns element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllGroupingColumns(Iterable<? extends GroupingColumnInfo> elements) {
            for (GroupingColumnInfo groupingColumnInfo : elements) {
                this.groupingColumns.add(Objects.requireNonNull(groupingColumnInfo, "groupingColumns element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addDataIndexes(DataIndexInfo element) {
            this.dataIndexes.add(Objects.requireNonNull(element, "dataIndexes element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addDataIndexes(DataIndexInfo ... elements) {
            for (DataIndexInfo element : elements) {
                this.dataIndexes.add(Objects.requireNonNull(element, "dataIndexes element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllDataIndexes(Iterable<? extends DataIndexInfo> elements) {
            for (DataIndexInfo dataIndexInfo : elements) {
                this.dataIndexes.add(Objects.requireNonNull(dataIndexInfo, "dataIndexes element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addColumnTypes(ColumnTypeInfo element) {
            this.columnTypes.add(Objects.requireNonNull(element, "columnTypes element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addColumnTypes(ColumnTypeInfo ... elements) {
            for (ColumnTypeInfo element : elements) {
                this.columnTypes.add(Objects.requireNonNull(element, "columnTypes element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllColumnTypes(Iterable<? extends ColumnTypeInfo> elements) {
            for (ColumnTypeInfo columnTypeInfo : elements) {
                this.columnTypes.add(Objects.requireNonNull(columnTypeInfo, "columnTypes element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addSortingColumns(SortColumnInfo element) {
            this.sortingColumns.add(Objects.requireNonNull(element, "sortingColumns element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addSortingColumns(SortColumnInfo ... elements) {
            for (SortColumnInfo element : elements) {
                this.sortingColumns.add(Objects.requireNonNull(element, "sortingColumns element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllSortingColumns(Iterable<? extends SortColumnInfo> elements) {
            for (SortColumnInfo sortColumnInfo : elements) {
                this.sortingColumns.add(Objects.requireNonNull(sortColumnInfo, "sortingColumns element"));
            }
            return this;
        }

        @Override
        public ImmutableTableInfo build() {
            return ImmutableTableInfo.validate(new ImmutableTableInfo(this));
        }

        private boolean versionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TableInfo is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TableInfo", generator="Immutables")
    static final class Json
    extends TableInfo {
        @Nullable
        String version;
        boolean versionIsSet;
        @Nullable
        List<GroupingColumnInfo> groupingColumns = Collections.emptyList();
        @Nullable
        List<DataIndexInfo> dataIndexes = Collections.emptyList();
        @Nullable
        List<ColumnTypeInfo> columnTypes = Collections.emptyList();
        @Nullable
        List<SortColumnInfo> sortingColumns = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
            this.versionIsSet = true;
        }

        @JsonProperty(value="groupingColumns")
        public void setGroupingColumns(List<GroupingColumnInfo> groupingColumns) {
            this.groupingColumns = groupingColumns;
        }

        @JsonProperty(value="dataIndexes")
        public void setDataIndexes(List<DataIndexInfo> dataIndexes) {
            this.dataIndexes = dataIndexes;
        }

        @JsonProperty(value="columnTypes")
        public void setColumnTypes(List<ColumnTypeInfo> columnTypes) {
            this.columnTypes = columnTypes;
        }

        @JsonProperty(value="sortingColumns")
        public void setSortingColumns(List<SortColumnInfo> sortingColumns) {
            this.sortingColumns = sortingColumns;
        }

        @Override
        public String version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<GroupingColumnInfo> groupingColumns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DataIndexInfo> dataIndexes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ColumnTypeInfo> columnTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SortColumnInfo> sortingColumns() {
            throw new UnsupportedOperationException();
        }
    }
}

