/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.SortColumn;
import io.deephaven.parquet.table.metadata.ImmutableSortColumnInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;

@JsonSerialize(as=ImmutableSortColumnInfo.class)
@JsonDeserialize(as=ImmutableSortColumnInfo.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@SimpleStyle
public abstract class SortColumnInfo {
    @Value.Parameter
    public abstract String columnName();

    @Value.Parameter
    public abstract SortDirection sortDirection();

    @Value.Check
    final void checkColumnName() {
        ColumnName.of((String)this.columnName());
    }

    public final SortColumn sortColumn() {
        return this.sortDirection() == SortDirection.Ascending ? SortColumn.asc((ColumnName)ColumnName.of((String)this.columnName())) : SortColumn.desc((ColumnName)ColumnName.of((String)this.columnName()));
    }

    public static List<SortColumn> sortColumns(@NotNull List<SortColumnInfo> sortColumnInfos) {
        return sortColumnInfos.stream().map(SortColumnInfo::sortColumn).collect(Collectors.toList());
    }

    public static SortColumnInfo of(@NotNull SortColumn sortColumn) {
        return SortColumnInfo.of(sortColumn.column().name(), sortColumn.order() == SortColumn.Order.ASCENDING ? SortDirection.Ascending : SortDirection.Descending);
    }

    public static SortColumnInfo of(@NotNull String columnName, @NotNull SortDirection sortDirection) {
        return ImmutableSortColumnInfo.of(columnName, sortDirection);
    }

    public static enum SortDirection {
        Ascending,
        Descending;

    }
}

