/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.metadata.DataIndexInfo;
import io.deephaven.parquet.table.metadata.GroupingColumnInfo;
import io.deephaven.parquet.table.metadata.ImmutableTableInfo;
import io.deephaven.parquet.table.metadata.SortColumnInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;

@JsonSerialize(as=ImmutableTableInfo.class)
@JsonDeserialize(as=ImmutableTableInfo.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@BuildableStyle
public abstract class TableInfo {
    private static final ObjectMapper OBJECT_MAPPER;

    public final String serializeToJSON() throws IOException {
        return OBJECT_MAPPER.writeValueAsString((Object)this);
    }

    public static TableInfo deserializeFromJSON(@NotNull String tableInfoRaw) throws IOException {
        return (TableInfo)OBJECT_MAPPER.readValue(tableInfoRaw, ImmutableTableInfo.class);
    }

    public final Map<String, GroupingColumnInfo> groupingColumnMap() {
        return this.groupingColumns().stream().collect(Collectors.toMap(GroupingColumnInfo::columnName, Function.identity()));
    }

    public final Map<String, ColumnTypeInfo> columnTypeMap() {
        return this.columnTypes().stream().collect(Collectors.toMap(ColumnTypeInfo::columnName, Function.identity()));
    }

    @Value.Default
    public String version() {
        String version = TableInfo.class.getPackage().getImplementationVersion();
        if (version == null) {
            return "unknown";
        }
        return version;
    }

    public abstract List<GroupingColumnInfo> groupingColumns();

    public abstract List<DataIndexInfo> dataIndexes();

    public abstract List<ColumnTypeInfo> columnTypes();

    public abstract List<SortColumnInfo> sortingColumns();

    @Value.Check
    final void checkVersion() {
        if (this.version().isEmpty()) {
            throw new IllegalArgumentException("Empty version");
        }
    }

    public static Builder builder() {
        return ImmutableTableInfo.builder();
    }

    static {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER = objectMapper;
    }

    public static interface Builder {
        public Builder version(String var1);

        public Builder addGroupingColumns(GroupingColumnInfo var1);

        public Builder addGroupingColumns(GroupingColumnInfo ... var1);

        public Builder addAllGroupingColumns(Iterable<? extends GroupingColumnInfo> var1);

        public Builder addDataIndexes(DataIndexInfo var1);

        public Builder addDataIndexes(DataIndexInfo ... var1);

        public Builder addAllDataIndexes(Iterable<? extends DataIndexInfo> var1);

        public Builder addColumnTypes(ColumnTypeInfo var1);

        public Builder addColumnTypes(ColumnTypeInfo ... var1);

        public Builder addAllColumnTypes(Iterable<? extends ColumnTypeInfo> var1);

        public Builder addSortingColumns(SortColumnInfo var1);

        public Builder addSortingColumns(SortColumnInfo ... var1);

        public Builder addAllSortingColumns(Iterable<? extends SortColumnInfo> var1);

        public TableInfo build();
    }
}

