/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.page.Page;
import io.deephaven.engine.page.PageStore;
import io.deephaven.engine.page.PagingContextHolder;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Context;
import io.deephaven.engine.table.Releasable;
import io.deephaven.engine.table.SharedContext;
import io.deephaven.engine.table.impl.chunkattributes.DictionaryKeys;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.table.pagestore.OffsetIndexBasedColumnChunkPageStore;
import io.deephaven.parquet.table.pagestore.PageCache;
import io.deephaven.parquet.table.pagestore.VariablePageSizeColumnChunkPageStore;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.vector.Vector;
import java.io.IOException;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ColumnChunkPageStore<ATTR extends Any>
implements PageStore<ATTR, ATTR, ChunkPage<ATTR>>,
Page<ATTR>,
SafeCloseable,
Releasable {
    final PageCache<ATTR> pageCache;
    final ColumnChunkReader columnChunkReader;
    private final long mask;
    final ToPage<ATTR, ?> toPage;
    private final long numRows;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");

    private static boolean canUseOffsetIndexBasedPageStore(@NotNull ColumnChunkReader columnChunkReader, @NotNull ColumnDefinition<?> columnDefinition) {
        if (!columnChunkReader.hasOffsetIndex()) {
            return false;
        }
        String version = columnChunkReader.getVersion();
        if (version == null) {
            return true;
        }
        Class columnType = columnDefinition.getDataType();
        if (columnType.isArray() || Vector.class.isAssignableFrom(columnType)) {
            return ColumnChunkPageStore.hasCorrectVectorOffsetIndexes(version);
        }
        return true;
    }

    @VisibleForTesting
    public static boolean hasCorrectVectorOffsetIndexes(@NotNull String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return true;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return major > 0 || major == 0 && minor >= 31;
    }

    public static <ATTR extends Any> CreatorResult<ATTR> create(@NotNull PageCache<ATTR> pageCache, @NotNull ColumnChunkReader columnChunkReader, long mask, @NotNull ToPage<ATTR, ?> toPage, @NotNull ColumnDefinition<?> columnDefinition) throws IOException {
        boolean canUseOffsetIndex = ColumnChunkPageStore.canUseOffsetIndexBasedPageStore(columnChunkReader, columnDefinition);
        ColumnChunkPageStore columnChunkPageStore = canUseOffsetIndex ? new OffsetIndexBasedColumnChunkPageStore<ATTR>(pageCache, columnChunkReader, mask, toPage) : new VariablePageSizeColumnChunkPageStore<ATTR>(pageCache, columnChunkReader, mask, toPage);
        ToPage<DictionaryKeys, long[]> dictionaryKeysToPage = toPage.getDictionaryKeysToPage();
        OffsetIndexBasedColumnChunkPageStore<DictionaryKeys> dictionaryKeysColumnChunkPageStore = dictionaryKeysToPage == null ? null : (canUseOffsetIndex ? new OffsetIndexBasedColumnChunkPageStore<DictionaryKeys>(pageCache.castAttr(), columnChunkReader, mask, dictionaryKeysToPage) : new VariablePageSizeColumnChunkPageStore<DictionaryKeys>(pageCache.castAttr(), columnChunkReader, mask, dictionaryKeysToPage));
        return new CreatorResult<ATTR>(columnChunkPageStore, toPage::getDictionaryChunk, dictionaryKeysColumnChunkPageStore);
    }

    ColumnChunkPageStore(@NotNull PageCache<ATTR> pageCache, @NotNull ColumnChunkReader columnChunkReader, long mask, ToPage<ATTR, ?> toPage) throws IOException {
        Require.requirement(((mask + 1L & mask) == 0L ? 1 : 0) != 0, (String)"mask is one less than a power of two");
        this.pageCache = pageCache;
        this.columnChunkReader = columnChunkReader;
        this.mask = mask;
        this.toPage = toPage;
        this.numRows = Require.inRange((long)columnChunkReader.numRows(), (String)"numRows", (long)mask, (String)"mask");
    }

    ChunkPage<ATTR> toPage(long offset, @NotNull ColumnPageReader columnPageReader, @NotNull SeekableChannelContext channelContext) throws IOException {
        return this.toPage.toPage(offset, columnPageReader, channelContext, this.mask);
    }

    public long mask() {
        return this.mask;
    }

    public long firstRowOffset() {
        return 0L;
    }

    public long numRows() {
        return this.numRows;
    }

    @NotNull
    public ChunkType getChunkType() {
        return this.toPage.getChunkType();
    }

    public boolean usesDictionaryOnEveryPage() {
        return this.columnChunkReader.usesDictionaryOnEveryPage();
    }

    public void close() {
    }

    final SeekableChannelContext innerFillContext(@Nullable ChunkSource.FillContext context) {
        if (context != null) {
            ChannelContextWrapper innerContext = (ChannelContextWrapper)((PagingContextHolder)context).updateInnerContext(this::fillContextUpdater);
            return innerContext.getChannelContext();
        }
        return SeekableChannelContext.NULL;
    }

    final SeekableChannelContext.ContextHolder ensureContext(@Nullable ChunkSource.FillContext context) {
        return SeekableChannelContext.ensureContext((SeekableChannelsProvider)this.columnChunkReader.getChannelsProvider(), (SeekableChannelContext)this.innerFillContext(context));
    }

    private <T extends ChunkSource.FillContext> T fillContextUpdater(int chunkCapacity, @Nullable SharedContext sharedContext, @Nullable Context currentInnerContext) {
        SeekableChannelContext channelContext;
        SeekableChannelsProvider channelsProvider = this.columnChunkReader.getChannelsProvider();
        if (currentInnerContext instanceof ChannelContextWrapper && channelsProvider.isCompatibleWith(channelContext = ((ChannelContextWrapper)currentInnerContext).getChannelContext())) {
            return (T)((ChunkSource.FillContext)currentInnerContext);
        }
        return (T)((Object)new ChannelContextWrapper(chunkCapacity, sharedContext, channelsProvider.makeContext()));
    }

    private static class ChannelContextWrapper
    extends PagingContextHolder {
        @NotNull
        private final SeekableChannelContext channelContext;

        private ChannelContextWrapper(int chunkCapacity, @Nullable SharedContext sharedContext, @NotNull SeekableChannelContext channelContext) {
            super(chunkCapacity, sharedContext);
            this.channelContext = channelContext;
        }

        @NotNull
        SeekableChannelContext getChannelContext() {
            return this.channelContext;
        }

        public void close() {
            super.close();
            this.channelContext.close();
        }
    }

    public static class CreatorResult<ATTR extends Any> {
        public final ColumnChunkPageStore<ATTR> pageStore;
        public final Supplier<Chunk<ATTR>> dictionaryChunkSupplier;
        public final ColumnChunkPageStore<DictionaryKeys> dictionaryKeysPageStore;

        private CreatorResult(@NotNull ColumnChunkPageStore<ATTR> pageStore, Supplier<Chunk<ATTR>> dictionaryChunkSupplier, ColumnChunkPageStore<DictionaryKeys> dictionaryKeysPageStore) {
            this.pageStore = pageStore;
            this.dictionaryChunkSupplier = dictionaryChunkSupplier;
            this.dictionaryKeysPageStore = dictionaryKeysPageStore;
        }
    }
}

