/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.pagestore.PageCache;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OffsetIndexBasedColumnChunkPageStore<ATTR extends Any>
extends ColumnChunkPageStore<ATTR> {
    private static final long PAGE_SIZE_NOT_FIXED = -1L;
    private static final int NUM_PAGES_NOT_INITIALIZED = -1;
    private volatile boolean isInitialized;
    private OffsetIndex offsetIndex;
    private int numPages = -1;
    private long fixedPageSize = -1L;
    private AtomicReferenceArray<PageState<ATTR>> pageStates;
    private ColumnChunkReader.ColumnPageDirectAccessor columnPageDirectAccessor;

    OffsetIndexBasedColumnChunkPageStore(@NotNull PageCache<ATTR> pageCache, @NotNull ColumnChunkReader columnChunkReader, long mask, @NotNull ToPage<ATTR, ?> toPage) throws IOException {
        super(pageCache, columnChunkReader, mask, toPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized(@Nullable ChunkSource.FillContext fillContext) {
        if (this.isInitialized) {
            return;
        }
        OffsetIndexBasedColumnChunkPageStore offsetIndexBasedColumnChunkPageStore = this;
        synchronized (offsetIndexBasedColumnChunkPageStore) {
            if (this.isInitialized) {
                return;
            }
            try (SeekableChannelContext.ContextHolder holder = SeekableChannelContext.ensureContext((SeekableChannelsProvider)this.columnChunkReader.getChannelsProvider(), (SeekableChannelContext)this.innerFillContext(fillContext));){
                this.offsetIndex = this.columnChunkReader.getOffsetIndex(holder.get());
            }
            Assert.neqNull((Object)this.offsetIndex, (String)"offsetIndex");
            this.numPages = this.offsetIndex.getPageCount();
            Assert.gtZero((int)this.numPages, (String)"numPages");
            this.pageStates = new AtomicReferenceArray(this.numPages);
            this.columnPageDirectAccessor = this.columnChunkReader.getPageAccessor(this.offsetIndex, this.toPage.getPageMaterializerFactory());
            if (this.numPages == 1) {
                this.fixedPageSize = this.numRows();
            } else {
                boolean isPageSizeFixed = true;
                long firstPageSize = this.offsetIndex.getFirstRowIndex(1) - this.offsetIndex.getFirstRowIndex(0);
                for (int i = 2; i < this.numPages; ++i) {
                    if (this.offsetIndex.getFirstRowIndex(i) - this.offsetIndex.getFirstRowIndex(i - 1) == firstPageSize) continue;
                    isPageSizeFixed = false;
                    break;
                }
                this.fixedPageSize = isPageSizeFixed ? firstPageSize : -1L;
            }
            this.isInitialized = true;
        }
    }

    private static int findPageNumUsingOffsetIndex(OffsetIndex offsetIndex, long row) {
        int low = 0;
        int high = offsetIndex.getPageCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = offsetIndex.getFirstRowIndex(mid);
            if (midVal < row) {
                low = mid + 1;
                continue;
            }
            if (midVal > row) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkPage<ATTR> getPage(@Nullable ChunkSource.FillContext fillContext, int pageNum) {
        PageCache.IntrusivePage<ATTR> page;
        PageState<ATTR> pageState;
        if (pageNum < 0 || pageNum >= this.numPages) {
            throw new IllegalArgumentException("pageNum " + pageNum + " is out of range [0, " + this.numPages + ")");
        }
        while ((pageState = this.pageStates.get(pageNum)) == null && !this.pageStates.weakCompareAndSetVolatile(pageNum, null, pageState = new PageState())) {
        }
        WeakReference localRef = pageState.pageRef;
        if (localRef == null || (page = (PageCache.IntrusivePage<ATTR>)((Object)localRef.get())) == null) {
            PageState<ATTR> pageState2 = pageState;
            synchronized (pageState2) {
                localRef = pageState.pageRef;
                if (localRef == null || (page = (PageCache.IntrusivePage)((Object)localRef.get())) == null) {
                    page = new PageCache.IntrusivePage<ATTR>(this.getPageImpl(fillContext, pageNum));
                    pageState.pageRef = new WeakReference<PageCache.IntrusivePage<ATTR>>(page);
                }
            }
        }
        this.pageCache.touch(page);
        return page.getPage();
    }

    private ChunkPage<ATTR> getPageImpl(@Nullable ChunkSource.FillContext fillContext, int pageNum) {
        ChunkPage chunkPage;
        block8: {
            SeekableChannelContext.ContextHolder holder = this.ensureContext(fillContext);
            try {
                ColumnPageReader reader = this.columnPageDirectAccessor.getPageReader(pageNum, holder.get());
                chunkPage = this.toPage(this.offsetIndex.getFirstRowIndex(pageNum), reader, holder.get());
                if (holder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (holder != null) {
                        try {
                            holder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            holder.close();
        }
        return chunkPage;
    }

    @NotNull
    public ChunkPage<ATTR> getPageContaining(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        ChunkPage<ATTR> chunkPage;
        block8: {
            ChunkSource.FillContext allocatedFillContext = fillContext != null ? null : this.makeFillContext(1, null);
            try {
                ChunkSource.FillContext fillContextToUse = fillContext != null ? fillContext : allocatedFillContext;
                this.ensureInitialized(fillContextToUse);
                chunkPage = this.getPageContainingImpl(fillContextToUse, rowKey);
                if (allocatedFillContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (allocatedFillContext != null) {
                        try {
                            allocatedFillContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new UncheckedDeephavenException("Failed to read parquet page data for row: " + rowKey + ", column: " + this.columnChunkReader.columnName() + ", uri: " + this.columnChunkReader.getURI(), (Throwable)e);
                }
            }
            allocatedFillContext.close();
        }
        return chunkPage;
    }

    @NotNull
    private ChunkPage<ATTR> getPageContainingImpl(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        int pageNum;
        Require.inRange((long)(rowKey &= this.mask()), (String)"rowKey", (long)this.numRows(), (String)"numRows");
        if (this.fixedPageSize == -1L) {
            pageNum = OffsetIndexBasedColumnChunkPageStore.findPageNumUsingOffsetIndex(this.offsetIndex, rowKey);
        } else {
            pageNum = (int)(rowKey / this.fixedPageSize);
            if (pageNum >= this.numPages) {
                Assert.geq((long)rowKey, (String)"row", (long)this.offsetIndex.getFirstRowIndex(this.numPages - 1), (String)"offsetIndex.getFirstRowIndex(numPages - 1)");
                pageNum = this.numPages - 1;
            }
        }
        return this.getPage(fillContext, pageNum);
    }

    private static final class PageState<ATTR extends Any> {
        private volatile WeakReference<PageCache.IntrusivePage<ATTR>> pageRef = null;

        PageState() {
        }
    }
}

