/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.pagestore.PageCache;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.channel.SeekableChannelContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VariablePageSizeColumnChunkPageStore<ATTR extends Any>
extends ColumnChunkPageStore<ATTR> {
    private volatile int numPages = 0;
    private volatile long[] pageRowOffsets;
    private volatile ColumnPageReader[] columnPageReaders;
    private final ColumnChunkReader.ColumnPageReaderIterator columnPageReaderIterator;
    private volatile WeakReference<PageCache.IntrusivePage<ATTR>>[] pages;

    VariablePageSizeColumnChunkPageStore(@NotNull PageCache<ATTR> pageCache, @NotNull ColumnChunkReader columnChunkReader, long mask, @NotNull ToPage<ATTR, ?> toPage) throws IOException {
        super(pageCache, columnChunkReader, mask, toPage);
        int INIT_ARRAY_SIZE = 15;
        this.pageRowOffsets = new long[16];
        this.pageRowOffsets[0] = 0L;
        this.columnPageReaders = new ColumnPageReader[15];
        this.columnPageReaderIterator = columnChunkReader.getPageIterator(toPage.getPageMaterializerFactory());
        this.pages = new WeakReference[15];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extendOnePage(@NotNull SeekableChannelContext channelContext, int prevNumPages) {
        PageCache.IntrusivePage page = null;
        VariablePageSizeColumnChunkPageStore variablePageSizeColumnChunkPageStore = this;
        synchronized (variablePageSizeColumnChunkPageStore) {
            int localNumPages = this.numPages;
            if (localNumPages == prevNumPages) {
                long numRows;
                Assert.assertion((boolean)this.columnPageReaderIterator.hasNext(), (String)"columnPageReaderIterator.hasNext()", (String)"Parquet num rows and page iterator don't match, not enough pages.");
                if (this.columnPageReaders.length == localNumPages) {
                    int newSize = 2 * localNumPages;
                    this.pageRowOffsets = Arrays.copyOf(this.pageRowOffsets, newSize + 1);
                    this.columnPageReaders = Arrays.copyOf(this.columnPageReaders, newSize);
                    this.pages = Arrays.copyOf(this.pages, newSize);
                }
                ColumnPageReader columnPageReader = this.columnPageReaderIterator.next(channelContext);
                WeakReference pageRef = PageCache.getNullPage();
                long prevRowOffset = this.pageRowOffsets[localNumPages];
                try {
                    numRows = columnPageReader.numRows(channelContext);
                    if (numRows < 0L) {
                        page = new PageCache.IntrusivePage(this.toPage(prevRowOffset, columnPageReader, channelContext));
                        pageRef = new WeakReference(page);
                        numRows = page.getPage().size();
                    }
                }
                catch (IOException except) {
                    throw new UncheckedIOException(except);
                }
                this.columnPageReaders[localNumPages] = columnPageReader;
                this.pages[localNumPages] = pageRef;
                this.pageRowOffsets[localNumPages + 1] = prevRowOffset + numRows;
                this.numPages = localNumPages + 1;
            }
        }
        if (page != null) {
            this.pageCache.touch((Object)page);
        }
    }

    private int fillToRow(@NotNull SeekableChannelContext channelContext, int minPageNum, long row) {
        int localNumPages = this.numPages;
        while (row >= this.pageRowOffsets[localNumPages]) {
            minPageNum = localNumPages;
            this.extendOnePage(channelContext, localNumPages);
            localNumPages = this.numPages;
        }
        return minPageNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkPage<ATTR> getPage(@NotNull SeekableChannelContext channelContext, int pageNum) {
        PageCache.IntrusivePage page = (PageCache.IntrusivePage)((Object)this.pages[pageNum].get());
        if (page == null) {
            ColumnPageReader columnPageReader = this.columnPageReaders[pageNum];
            synchronized (columnPageReader) {
                page = (PageCache.IntrusivePage)((Object)this.pages[pageNum].get());
                if (page == null) {
                    try {
                        page = new PageCache.IntrusivePage(this.toPage(this.pageRowOffsets[pageNum], this.columnPageReaders[pageNum], channelContext));
                    }
                    catch (IOException except) {
                        throw new UncheckedIOException(except);
                    }
                    VariablePageSizeColumnChunkPageStore variablePageSizeColumnChunkPageStore = this;
                    synchronized (variablePageSizeColumnChunkPageStore) {
                        this.pages[pageNum] = new WeakReference(page);
                    }
                }
            }
        }
        this.pageCache.touch((Object)page);
        return page.getPage();
    }

    @NotNull
    public ChunkPage<ATTR> getPageContaining(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        try {
            return this.getPageContainingImpl(fillContext, rowKey);
        }
        catch (RuntimeException e) {
            throw new UncheckedDeephavenException("Failed to read parquet page data for row: " + rowKey + ", column: " + this.columnChunkReader.columnName() + ", uri: " + this.columnChunkReader.getURI(), (Throwable)e);
        }
    }

    @NotNull
    private ChunkPage<ATTR> getPageContainingImpl(@Nullable ChunkSource.FillContext fillContext, long rowKey) {
        Require.inRange((long)((rowKey &= this.mask()) - this.pageRowOffsets[0]), (String)"rowKey", (long)this.numRows(), (String)"numRows");
        int localNumPages = this.numPages;
        int pageNum = Arrays.binarySearch(this.pageRowOffsets, 1, localNumPages + 1, rowKey);
        if (pageNum < 0) {
            pageNum = -2 - pageNum;
        }
        try (SeekableChannelContext.ContextHolder holder = this.ensureContext(fillContext);){
            int minPageNum;
            if (pageNum >= localNumPages && (pageNum = Arrays.binarySearch(this.pageRowOffsets, (minPageNum = this.fillToRow(holder.get(), localNumPages, rowKey)) + 1, (localNumPages = this.numPages) + 1, rowKey)) < 0) {
                pageNum = -2 - pageNum;
            }
            ChunkPage<ATTR> chunkPage = this.getPage(holder.get(), pageNum);
            return chunkPage;
        }
    }
}

