/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.stringset.LongBitmapStringSet;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.datastructures.SoftCachingSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.parquet.column.Dictionary;
import org.jetbrains.annotations.NotNull;

public class ChunkDictionary<T, ATTR extends Any>
implements LongBitmapStringSet.ReversibleLookup<T> {
    private final Supplier<ObjectChunk<T, ATTR>> valuesSupplier = new SoftCachingSupplier(() -> {
        Dictionary dictionary = (Dictionary)dictionarySupplier.apply(SeekableChannelContext.NULL);
        Object[] values = ObjectChunk.makeArray((int)(dictionary.getMaxId() + 1));
        for (int ki = 0; ki < values.length; ++ki) {
            values[ki] = lookup.lookup(dictionary, ki);
        }
        return ObjectChunk.chunkWrap((Object[])values);
    });
    private final Supplier<TObjectIntMap<T>> reverseMapSupplier = new SoftCachingSupplier(() -> {
        ObjectChunk<T, ATTR> values = this.getChunk();
        TObjectIntHashMap reverseMap = new TObjectIntHashMap(values.size());
        for (int vi = 0; vi < values.size(); ++vi) {
            reverseMap.put(values.get(vi), vi);
        }
        return reverseMap;
    });

    ChunkDictionary(@NotNull Lookup<T> lookup, @NotNull Function<SeekableChannelContext, Dictionary> dictionarySupplier) {
    }

    ObjectChunk<T, ATTR> getChunk() {
        return this.valuesSupplier.get();
    }

    public final T get(long index) {
        ObjectChunk<T, ATTR> values = this.getChunk();
        return (T)(index < 0L || index >= (long)values.size() ? null : values.get((int)index));
    }

    public final int rget(int highestIndex, T value) {
        return this.reverseMapSupplier.get().get(value);
    }

    public final int length() {
        return this.getChunk().size();
    }

    @FunctionalInterface
    public static interface Lookup<T> {
        public T lookup(@NotNull Dictionary var1, int var2);
    }
}

