/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.DataWithOffsets;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.vector.Vector;
import java.lang.reflect.Array;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;

public class ToArrayPage<ATTR extends Any, RESULT, ARRAY_TYPE>
extends ToPage.Wrap<ATTR, RESULT, ARRAY_TYPE[]> {
    private final Class<ARRAY_TYPE> nativeType;

    public static <ATTR extends Any, ARRAY_TYPE> ToPage<ATTR, ARRAY_TYPE[]> create(@NotNull Class<ARRAY_TYPE> nativeType, @NotNull Class<?> componentType, @NotNull ToPage<ATTR, ?> toPage) {
        if (!nativeType.isArray()) {
            throw new IllegalArgumentException("Native type " + nativeType + " is not an array type.");
        }
        Class<?> columnComponentType = toPage.getNativeComponentType();
        if (!componentType.isAssignableFrom(columnComponentType)) {
            throw new IllegalArgumentException("The component type " + componentType.getCanonicalName() + " for the array type " + nativeType.getCanonicalName() + " is not compatible with the column's component type " + columnComponentType);
        }
        return new ToArrayPage(nativeType, toPage);
    }

    private ToArrayPage(@NotNull Class<ARRAY_TYPE> nativeType, @NotNull ToPage<ATTR, RESULT> toPage) {
        super(toPage);
        this.nativeType = nativeType;
    }

    @Override
    @NotNull
    public final Class<ARRAY_TYPE> getNativeType() {
        return this.nativeType;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final ARRAY_TYPE[] convertResult(Object object) {
        DataWithOffsets dataWithOffsets = (DataWithOffsets)object;
        Vector<?> dataWrapper = this.toPage.makeVector(this.toPage.convertResult(dataWithOffsets.materializeResult));
        IntBuffer offsets = dataWithOffsets.offsets;
        Object[] to = (Object[])Array.newInstance(this.nativeType, offsets.remaining());
        int lastOffset = 0;
        for (int vi = 0; vi < to.length; ++vi) {
            int nextOffset = offsets.get();
            if (nextOffset == -1) {
                to[vi] = null;
                continue;
            }
            to[vi] = dataWrapper.subVector((long)lastOffset, (long)nextOffset).toArray();
            lastOffset = nextOffset;
        }
        return to;
    }
}

