/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.BigDecimalFromIntMaterializer;
import io.deephaven.parquet.base.materializers.BigDecimalFromLongMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;

public class ToBigDecimalFromNumeric<ATTR extends Any>
implements ToPage<ATTR, BigDecimal[]> {
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToPage<ATTR, BigDecimal[]> createFromInt(@NotNull Class<?> nativeType, int scale) {
        return new ToBigDecimalFromNumeric<ATTR>(nativeType, (PageMaterializerFactory)new BigDecimalFromIntMaterializer.Factory(scale));
    }

    public static <ATTR extends Any> ToPage<ATTR, BigDecimal[]> createFromLong(@NotNull Class<?> nativeType, int scale) {
        return new ToBigDecimalFromNumeric<ATTR>(nativeType, (PageMaterializerFactory)new BigDecimalFromLongMaterializer.Factory(scale));
    }

    private ToBigDecimalFromNumeric(@NotNull Class<?> nativeType, @NotNull PageMaterializerFactory pageMaterializerFactory) {
        if (!BigDecimal.class.equals(nativeType)) {
            throw new IllegalArgumentException("The native type for a BigDecimal column is " + nativeType.getCanonicalName());
        }
        this.pageMaterializerFactory = pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Class<?> getNativeType() {
        return BigDecimal.class;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

