/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.BigDecimalFromBytesMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ChunkDictionary;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.parquet.table.pagestore.topage.ToPageWithDictionary;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigDecimal;
import java.util.function.Function;
import org.apache.parquet.column.Dictionary;
import org.jetbrains.annotations.NotNull;

public class ToBigDecimalPage<ATTR extends Any>
implements ToPage<ATTR, BigDecimal[]> {
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToPage<ATTR, BigDecimal[]> create(Class<?> nativeType, @NotNull ObjectCodec<BigDecimal> codec, Function<SeekableChannelContext, Dictionary> dictionarySupplier) {
        if (nativeType == null || BigDecimal.class.equals(nativeType)) {
            if (dictionarySupplier == null) {
                return new ToBigDecimalPage<ATTR>(codec);
            }
            return new ToPageWithDictionary(BigDecimal.class, new ChunkDictionary((dictionary, key) -> (BigDecimal)codec.decode(dictionary.decodeToBinary(key).toByteBuffer()), dictionarySupplier), result -> (BigDecimal[])result, (PageMaterializerFactory)new BigDecimalFromBytesMaterializer.Factory(codec));
        }
        throw new IllegalArgumentException("The native type for a BigDecimal column is " + nativeType.getCanonicalName());
    }

    private ToBigDecimalPage(@NotNull ObjectCodec<BigDecimal> codec) {
        this.pageMaterializerFactory = new BigDecimalFromBytesMaterializer.Factory(codec);
    }

    @Override
    @NotNull
    public final Class<?> getNativeType() {
        return BigDecimal.class;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

