/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.BigIntegerMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ChunkDictionary;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.parquet.table.pagestore.topage.ToPageWithDictionary;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigInteger;
import java.util.function.Function;
import org.apache.parquet.column.Dictionary;
import org.jetbrains.annotations.NotNull;

public class ToBigIntegerPage<ATTR extends Any>
implements ToPage<ATTR, BigInteger[]> {
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToPage<ATTR, BigInteger[]> create(Class<?> nativeType, @NotNull ObjectCodec<BigInteger> codec, Function<SeekableChannelContext, Dictionary> dictionarySupplier) {
        if (nativeType == null || BigInteger.class.equals(nativeType)) {
            if (dictionarySupplier == null) {
                return new ToBigIntegerPage<ATTR>(codec);
            }
            return new ToPageWithDictionary(BigInteger.class, new ChunkDictionary((dictionary, key) -> (BigInteger)codec.decode(dictionary.decodeToBinary(key).toByteBuffer()), dictionarySupplier), result -> (BigInteger[])result, (PageMaterializerFactory)new BigIntegerMaterializer.Factory(codec));
        }
        throw new IllegalArgumentException("The native type for a BigInteger column is " + nativeType.getCanonicalName());
    }

    private ToBigIntegerPage(@NotNull ObjectCodec<BigInteger> codec) {
        this.pageMaterializerFactory = new BigIntegerMaterializer.Factory(codec);
    }

    @Override
    @NotNull
    public final Class<?> getNativeType() {
        return BigInteger.class;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

