/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.ByteMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.QueryConstants;
import org.jetbrains.annotations.NotNull;

public class ToBytePage<ATTR extends Any>
implements ToPage<ATTR, byte[]> {
    private static final ToBytePage INSTANCE = new ToBytePage();

    public static <ATTR extends Any> ToBytePage<ATTR> create(Class<?> nativeType) {
        if (nativeType == null || Byte.TYPE.equals(nativeType)) {
            return INSTANCE;
        }
        throw new IllegalArgumentException("The native type for a Byte column is " + nativeType.getCanonicalName());
    }

    private ToBytePage() {
    }

    @Override
    @NotNull
    public final Class<Byte> getNativeType() {
        return Byte.TYPE;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Byte;
    }

    @Override
    @NotNull
    public final Object nullValue() {
        return QueryConstants.NULL_BYTE_BOXED;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return ByteMaterializer.FACTORY;
    }
}

