/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.CharMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.QueryConstants;
import org.jetbrains.annotations.NotNull;

public class ToCharPage<ATTR extends Any>
implements ToPage<ATTR, char[]> {
    private static final ToCharPage INSTANCE = new ToCharPage();

    public static <ATTR extends Any> ToCharPage<ATTR> create(Class<?> nativeType) {
        if (nativeType == null || Character.TYPE.equals(nativeType)) {
            return INSTANCE;
        }
        throw new IllegalArgumentException("The native type for a Char column is " + nativeType.getCanonicalName());
    }

    private ToCharPage() {
    }

    @Override
    @NotNull
    public final Class<Character> getNativeType() {
        return Character.TYPE;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Char;
    }

    @Override
    @NotNull
    public final Object nullValue() {
        return QueryConstants.NULL_CHAR_BOXED;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return CharMaterializer.FACTORY;
    }
}

