/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.FloatMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.QueryConstants;
import org.jetbrains.annotations.NotNull;

public class ToFloatPage<ATTR extends Any>
implements ToPage<ATTR, float[]> {
    private static final ToFloatPage INSTANCE = new ToFloatPage();

    public static <ATTR extends Any> ToFloatPage<ATTR> create(Class<?> nativeType) {
        if (nativeType == null || Float.TYPE.equals(nativeType)) {
            return INSTANCE;
        }
        throw new IllegalArgumentException("The native type for a Float column is " + nativeType.getCanonicalName());
    }

    private ToFloatPage() {
    }

    @Override
    @NotNull
    public final Class<Float> getNativeType() {
        return Float.TYPE;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Float;
    }

    @Override
    @NotNull
    public final Object nullValue() {
        return QueryConstants.NULL_FLOAT_BOXED;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return FloatMaterializer.FACTORY;
    }
}

