/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.InstantNanosFromInt96Materializer;
import io.deephaven.parquet.base.materializers.InstantNanosFromMicrosMaterializer;
import io.deephaven.parquet.base.materializers.InstantNanosFromMillisMaterializer;
import io.deephaven.parquet.base.materializers.LongMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.QueryConstants;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ObjectVectorDirect;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ToInstantPage<ATTR extends Any>
implements ToPage<ATTR, long[]> {
    private static final ToPage FROM_MILLIS = new ToInstantPage(InstantNanosFromMillisMaterializer.FACTORY);
    private static final ToPage FROM_MICROS = new ToInstantPage(InstantNanosFromMicrosMaterializer.FACTORY);
    private static final ToPage FROM_NANOS = new ToInstantPage(LongMaterializer.FACTORY);
    private static final ToPage FROM_INT96 = new ToInstantPage(InstantNanosFromInt96Materializer.FACTORY);
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToPage<ATTR, Instant[]> createFromMillis(Class<?> nativeType) {
        ToInstantPage.verifyNativeType(nativeType);
        return FROM_MILLIS;
    }

    public static <ATTR extends Any> ToPage<ATTR, Instant[]> createFromMicros(Class<?> nativeType) {
        ToInstantPage.verifyNativeType(nativeType);
        return FROM_MICROS;
    }

    public static <ATTR extends Any> ToPage<ATTR, Instant[]> createFromNanos(Class<?> nativeType) {
        ToInstantPage.verifyNativeType(nativeType);
        return FROM_NANOS;
    }

    public static <ATTR extends Any> ToPage<ATTR, Instant[]> createFromInt96(Class<?> nativeType) {
        ToInstantPage.verifyNativeType(nativeType);
        return FROM_INT96;
    }

    private static void verifyNativeType(Class<?> nativeType) {
        if (nativeType != null && !Instant.class.equals(nativeType)) {
            throw new IllegalArgumentException("The native type for an Instant column is " + nativeType.getCanonicalName());
        }
    }

    private ToInstantPage(@NotNull PageMaterializerFactory pageMaterializerFactory) {
        this.pageMaterializerFactory = pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Class<Long> getNativeType() {
        return Long.TYPE;
    }

    @Override
    @NotNull
    public final Class<Instant> getNativeComponentType() {
        return Instant.class;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Long;
    }

    @Override
    @NotNull
    public final Object nullValue() {
        return QueryConstants.NULL_LONG_BOXED;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }

    @Override
    @NotNull
    public ObjectVector<Instant> makeVector(long[] result) {
        Object[] to = new Instant[result.length];
        for (int i = 0; i < result.length; ++i) {
            to[i] = DateTimeUtils.epochNanosToInstant((long)result[i]);
        }
        return new ObjectVectorDirect(to);
    }
}

