/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.LocalDateTimeFromMicrosMaterializer;
import io.deephaven.parquet.base.materializers.LocalDateTimeFromMillisMaterializer;
import io.deephaven.parquet.base.materializers.LocalDateTimeFromNanosMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

public class ToLocalDateTimePage<ATTR extends Any>
implements ToPage<ATTR, LocalDateTime[]> {
    private static final ToPage FROM_MILLIS = new ToLocalDateTimePage(LocalDateTimeFromMillisMaterializer.FACTORY);
    private static final ToPage FROM_MICROS = new ToLocalDateTimePage(LocalDateTimeFromMicrosMaterializer.FACTORY);
    private static final ToPage FROM_NANOS = new ToLocalDateTimePage(LocalDateTimeFromNanosMaterializer.FACTORY);
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToPage<ATTR, LocalDateTime[]> createFromMillis(Class<?> nativeType) {
        ToLocalDateTimePage.verifyNativeType(nativeType);
        return FROM_MILLIS;
    }

    public static <ATTR extends Any> ToPage<ATTR, LocalDateTime[]> createFromMicros(Class<?> nativeType) {
        ToLocalDateTimePage.verifyNativeType(nativeType);
        return FROM_MICROS;
    }

    public static <ATTR extends Any> ToPage<ATTR, LocalDateTime[]> createFromNanos(Class<?> nativeType) {
        ToLocalDateTimePage.verifyNativeType(nativeType);
        return FROM_NANOS;
    }

    private static void verifyNativeType(Class<?> nativeType) {
        if (nativeType != null && !LocalDateTime.class.equals(nativeType)) {
            throw new IllegalArgumentException("The native type for a LocalDateTime column is " + nativeType.getCanonicalName());
        }
    }

    private ToLocalDateTimePage(@NotNull PageMaterializerFactory pageMaterializerFactory) {
        this.pageMaterializerFactory = pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Class<LocalDateTime> getNativeType() {
        return LocalDateTime.class;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

