/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.LocalTimeFromMicrosMaterializer;
import io.deephaven.parquet.base.materializers.LocalTimeFromMillisMaterializer;
import io.deephaven.parquet.base.materializers.LocalTimeFromNanosMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import java.time.LocalTime;
import org.jetbrains.annotations.NotNull;

public class ToLocalTimePage<ATTR extends Any>
implements ToPage<ATTR, LocalTime[]> {
    private static final ToPage FROM_MILLIS = new ToLocalTimePage(LocalTimeFromMillisMaterializer.FACTORY);
    private static final ToPage FROM_MICROS = new ToLocalTimePage(LocalTimeFromMicrosMaterializer.FACTORY);
    private static final ToPage FROM_NANOS = new ToLocalTimePage(LocalTimeFromNanosMaterializer.FACTORY);
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToPage<ATTR, LocalTime[]> createFromMillis(Class<?> nativeType) {
        ToLocalTimePage.verifyNativeType(nativeType);
        return FROM_MILLIS;
    }

    public static <ATTR extends Any> ToPage<ATTR, LocalTime[]> createFromMicros(Class<?> nativeType) {
        ToLocalTimePage.verifyNativeType(nativeType);
        return FROM_MICROS;
    }

    public static <ATTR extends Any> ToPage<ATTR, LocalTime[]> createFromNanos(Class<?> nativeType) {
        ToLocalTimePage.verifyNativeType(nativeType);
        return FROM_NANOS;
    }

    private static void verifyNativeType(Class<?> nativeType) {
        if (nativeType != null && !LocalTime.class.equals(nativeType)) {
            throw new IllegalArgumentException("The native type for a LocalTime column is " + nativeType.getCanonicalName());
        }
    }

    private ToLocalTimePage(@NotNull PageMaterializerFactory pageMaterializerFactory) {
        this.pageMaterializerFactory = pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Class<LocalTime> getNativeType() {
        return LocalTime.class;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

