/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.LongFromUnsignedIntMaterializer;
import io.deephaven.parquet.base.materializers.LongMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.util.QueryConstants;
import org.jetbrains.annotations.NotNull;

public class ToLongPage<ATTR extends Any>
implements ToPage<ATTR, long[]> {
    private static final ToLongPage FROM_LONG = new ToLongPage(LongMaterializer.FACTORY);
    private static final ToLongPage FROM_UNSIGNED_INT = new ToLongPage(LongFromUnsignedIntMaterializer.FACTORY);
    private final PageMaterializerFactory pageMaterializerFactory;

    public static <ATTR extends Any> ToLongPage<ATTR> create(Class<?> nativeType) {
        ToLongPage.verifyNativeType(nativeType);
        return FROM_LONG;
    }

    public static <ATTR extends Any> ToLongPage<ATTR> createFromUnsignedInt(Class<?> nativeType) {
        ToLongPage.verifyNativeType(nativeType);
        return FROM_UNSIGNED_INT;
    }

    private static void verifyNativeType(Class<?> nativeType) {
        if (nativeType == null || Long.TYPE.equals(nativeType)) {
            return;
        }
        throw new IllegalArgumentException("The native type for a Long column is " + nativeType.getCanonicalName());
    }

    private ToLongPage(@NotNull PageMaterializerFactory pageMaterializerFactory) {
        this.pageMaterializerFactory = pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Class<Long> getNativeType() {
        return Long.TYPE;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Long;
    }

    @Override
    @NotNull
    public final Object nullValue() {
        return QueryConstants.NULL_LONG_BOXED;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

