/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.ObjectMaterializer;
import io.deephaven.parquet.table.pagestore.topage.ChunkDictionary;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.parquet.table.pagestore.topage.ToPageWithDictionary;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.codec.ObjectCodec;
import java.util.function.Function;
import org.apache.parquet.column.Dictionary;
import org.jetbrains.annotations.NotNull;

public class ToObjectPage<T, ATTR extends Any>
implements ToPage<ATTR, T[]> {
    private final PageMaterializerFactory pageMaterializerFactory;
    private final Class<T> nativeType;

    public static <T, ATTR extends Any> ToPage<ATTR, T[]> create(Class<T> nativeType, @NotNull ObjectCodec<T> codec, Function<SeekableChannelContext, Dictionary> dictionarySupplier) {
        if (!nativeType.isPrimitive()) {
            if (dictionarySupplier == null) {
                return new ToObjectPage<T, ATTR>(nativeType, codec);
            }
            return new ToPageWithDictionary(nativeType, new ChunkDictionary((dictionary, key) -> codec.decode(dictionary.decodeToBinary(key).toByteBuffer()), dictionarySupplier), result -> (Object[])result, (PageMaterializerFactory)new ObjectMaterializer.Factory(codec, nativeType));
        }
        throw new IllegalArgumentException("The native type for a Object column is " + nativeType.getCanonicalName());
    }

    private ToObjectPage(Class<T> nativeType, ObjectCodec<T> codec) {
        this.nativeType = nativeType;
        this.pageMaterializerFactory = new ObjectMaterializer.Factory(codec, nativeType);
    }

    @Override
    @NotNull
    public final Class<?> getNativeType() {
        return this.nativeType;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }
}

