/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.table.impl.chunkattributes.DictionaryKeys;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.base.DataWithOffsets;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.table.pagestore.topage.ChunkDictionary;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.stringset.LongBitmapStringSet;
import io.deephaven.util.channel.SeekableChannelContext;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.IntBuffer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ToPageWithDictionary<DATA_TYPE, ATTR extends Any>
implements ToPage<ATTR, DATA_TYPE[]> {
    private final Class<DATA_TYPE> nativeType;
    private final ChunkDictionary<DATA_TYPE, ATTR> chunkDictionary;
    private final Function<Object, DATA_TYPE[]> convertResultFallbackFun;
    private final PageMaterializerFactory pageMaterializerFactory;

    ToPageWithDictionary(@NotNull Class<DATA_TYPE> nativeType, @NotNull ChunkDictionary<DATA_TYPE, ATTR> chunkDictionary, @NotNull Function<Object, DATA_TYPE[]> convertResultFallbackFun, @NotNull PageMaterializerFactory pageMaterializerFactory) {
        this.nativeType = nativeType;
        this.chunkDictionary = chunkDictionary;
        this.convertResultFallbackFun = convertResultFallbackFun;
        this.pageMaterializerFactory = pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Class<DATA_TYPE> getNativeType() {
        return this.nativeType;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final PageMaterializerFactory getPageMaterializerFactory() {
        return this.pageMaterializerFactory;
    }

    @Override
    @NotNull
    public final Object getResult(@NotNull ColumnPageReader columnPageReader, @NotNull SeekableChannelContext channelContext) throws IOException {
        Object object;
        if (columnPageReader.getDictionary(channelContext) == ColumnChunkReader.NULL_DICTIONARY) {
            return ToPage.super.getResult(columnPageReader, channelContext);
        }
        int[] keys = new int[columnPageReader.numValues()];
        IntBuffer offsets = columnPageReader.readKeyValues(IntBuffer.wrap(keys), Integer.MIN_VALUE, channelContext);
        if (offsets == null) {
            object = keys;
        } else {
            DataWithOffsets dataWithOffsets;
            object = dataWithOffsets;
            dataWithOffsets = new DataWithOffsets(offsets, (Object)keys);
        }
        return object;
    }

    @Override
    @NotNull
    public final DATA_TYPE[] convertResult(@NotNull Object result) {
        if (!(result instanceof int[])) {
            return this.convertResultFallbackFun.apply(result);
        }
        int[] from = (int[])result;
        Object[] to = (Object[])Array.newInstance(this.nativeType, from.length);
        for (int ii = 0; ii < from.length; ++ii) {
            to[ii] = this.chunkDictionary.get(from[ii]);
        }
        return to;
    }

    @NotNull
    public final ObjectChunk<DATA_TYPE, ATTR> getDictionaryChunk() {
        return this.chunkDictionary.getChunk();
    }

    @Override
    @NotNull
    public final LongBitmapStringSet.ReversibleLookup<DATA_TYPE> getReversibleLookup() {
        return this.chunkDictionary;
    }

    @Override
    @NotNull
    public final ToPage<DictionaryKeys, long[]> getDictionaryKeysToPage() {
        return new ToPage<DictionaryKeys, long[]>(){

            @Override
            @NotNull
            public Class<?> getNativeType() {
                return Long.TYPE;
            }

            @Override
            @NotNull
            public ChunkType getChunkType() {
                return ChunkType.Long;
            }

            @Override
            public Object nullValue() {
                return Integer.MIN_VALUE;
            }

            @Override
            @NotNull
            public PageMaterializerFactory getPageMaterializerFactory() {
                return PageMaterializerFactory.NULL_FACTORY;
            }

            @Override
            public Object getResult(@NotNull ColumnPageReader columnPageReader, @NotNull SeekableChannelContext channelContext) throws IOException {
                return ToPageWithDictionary.this.getResult(columnPageReader, channelContext);
            }

            @Override
            public long[] convertResult(@NotNull Object result) {
                int[] from = (int[])result;
                long[] to = new long[from.length];
                for (int ii = 0; ii < from.length; ++ii) {
                    int intKey = from[ii];
                    to[ii] = intKey == Integer.MIN_VALUE ? Long.MIN_VALUE : (long)intKey;
                }
                return to;
            }
        };
    }
}

