/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.pagestore.topage;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.parquet.base.DataWithOffsets;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.vector.Vector;
import java.lang.reflect.Array;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;

public class ToVectorPage<ATTR extends Any, RESULT, VECTOR_TYPE extends Vector<?>>
extends ToPage.Wrap<ATTR, RESULT, VECTOR_TYPE[]> {
    private final Class<VECTOR_TYPE> nativeType;

    public static <ATTR extends Any> ToPage<ATTR, ?> create(@NotNull Class<?> nativeType, @NotNull Class<?> componentType, @NotNull ToPage<ATTR, ?> toPage) {
        if (!Vector.class.isAssignableFrom(nativeType)) {
            throw new IllegalArgumentException("Native type " + nativeType + " is not a Vector type.");
        }
        Class<?> columnComponentType = toPage.getNativeComponentType();
        if (!componentType.isAssignableFrom(columnComponentType)) {
            throw new IllegalArgumentException("The component type " + componentType.getCanonicalName() + " for the array type " + nativeType.getCanonicalName() + " is not compatible with the column's component type " + columnComponentType);
        }
        return new ToVectorPage(nativeType, toPage);
    }

    private ToVectorPage(@NotNull Class<VECTOR_TYPE> nativeType, @NotNull ToPage<ATTR, RESULT> toPage) {
        super(toPage);
        this.nativeType = nativeType;
    }

    @Override
    @NotNull
    public final Class<VECTOR_TYPE> getNativeType() {
        return this.nativeType;
    }

    @Override
    @NotNull
    public final ChunkType getChunkType() {
        return ChunkType.Object;
    }

    @Override
    @NotNull
    public final VECTOR_TYPE[] convertResult(Object object) {
        DataWithOffsets dataWithOffsets = (DataWithOffsets)object;
        Vector<?> dataWrapper = this.toPage.makeVector(this.toPage.convertResult(dataWithOffsets.materializeResult));
        IntBuffer offsets = dataWithOffsets.offsets;
        Vector[] to = (Vector[])Array.newInstance(this.nativeType, offsets.remaining());
        int lastOffset = 0;
        for (int vi = 0; vi < to.length; ++vi) {
            int nextOffset = offsets.get();
            if (nextOffset == -1) {
                to[vi] = null;
                continue;
            }
            to[vi] = dataWrapper.subVector((long)lastOffset, (long)nextOffset).getDirect();
            lastOffset = nextOffset;
        }
        return to;
    }
}

