/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.impl.sources.regioned.GenericColumnRegionBase;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.jetbrains.annotations.NotNull;

public abstract class ParquetColumnRegionBase<ATTR extends Any>
extends GenericColumnRegionBase<ATTR>
implements ParquetColumnRegion<ATTR> {
    final ColumnChunkPageStore<ATTR> columnChunkPageStore;

    ParquetColumnRegionBase(long pageMask, @NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore) {
        super(pageMask);
        this.columnChunkPageStore = (ColumnChunkPageStore)Require.neqNull(columnChunkPageStore, (String)"columnChunkPageStore");
        Require.eq((long)columnChunkPageStore.mask(), (String)"columnChunkPageStore.mask()", (long)this.mask(), (String)"ColumnRegion.mask()");
        Require.eq((long)columnChunkPageStore.firstRowOffset(), (String)"columnChunkPageStore.firstRowOffset()", (long)this.firstRowOffset(), (String)"ColumnRegion.firstRowOffset()");
    }

    public final Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, @NotNull RowSequence rowSequence) {
        this.throwIfInvalidated();
        return this.columnChunkPageStore.getChunk(context, rowSequence);
    }

    public final Chunk<? extends ATTR> getChunk(@NotNull ChunkSource.GetContext context, long firstKey, long lastKey) {
        this.throwIfInvalidated();
        return this.columnChunkPageStore.getChunk(context, firstKey, lastKey);
    }

    public final void fillChunk(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super ATTR> destination, @NotNull RowSequence rowSequence) {
        this.throwIfInvalidated();
        this.columnChunkPageStore.fillChunk(context, destination, rowSequence);
    }

    public final void fillChunkAppend(@NotNull ChunkSource.FillContext context, @NotNull WritableChunk<? super ATTR> destination, @NotNull RowSequence.Iterator rowSequenceIterator) {
        this.throwIfInvalidated();
        this.columnChunkPageStore.fillChunkAppend(context, destination, rowSequenceIterator);
    }

    @Override
    public final ChunkPage<ATTR> getChunkPageContaining(long elementIndex) {
        this.throwIfInvalidated();
        return (ChunkPage)this.columnChunkPageStore.getPageContaining(null, elementIndex);
    }

    @OverridingMethodsMustInvokeSuper
    public void releaseCachedResources() {
        ParquetColumnRegion.super.releaseCachedResources();
        this.columnChunkPageStore.releaseCachedResources();
    }
}

