/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionByte;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import io.deephaven.parquet.table.region.ParquetColumnRegionBase;
import org.jetbrains.annotations.NotNull;

public final class ParquetColumnRegionByte<ATTR extends Any>
extends ParquetColumnRegionBase<ATTR>
implements ColumnRegionByte<ATTR>,
ParquetColumnRegion<ATTR> {
    public ParquetColumnRegionByte(@NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore) {
        super(columnChunkPageStore.mask(), columnChunkPageStore);
    }

    public byte[] getBytes(long firstRowKey, @NotNull byte[] destination, int destinationOffset, int length) {
        WritableByteChunk byteChunk = WritableByteChunk.writableChunkWrap((byte[])destination, (int)destinationOffset, (int)length);
        try (RowSequence rowSequence = RowSequenceFactory.forRange((long)firstRowKey, (long)(firstRowKey + (long)length - 1L));){
            this.fillChunk(DEFAULT_FILL_INSTANCE, byteChunk, rowSequence);
        }
        return destination;
    }

    public byte getByte(long rowKey) {
        ChunkPage page = this.getChunkPageContaining(rowKey);
        try {
            return page.asByteChunk().get(page.getChunkOffset(rowKey));
        }
        catch (Exception e) {
            throw new TableDataException("Error retrieving byte at row key " + rowKey + " from a parquet table", (Throwable)e);
        }
    }
}

