/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionChar;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import io.deephaven.parquet.table.region.ParquetColumnRegionBase;
import org.jetbrains.annotations.NotNull;

public final class ParquetColumnRegionChar<ATTR extends Any>
extends ParquetColumnRegionBase<ATTR>
implements ColumnRegionChar<ATTR>,
ParquetColumnRegion<ATTR> {
    public ParquetColumnRegionChar(@NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore) {
        super(columnChunkPageStore.mask(), columnChunkPageStore);
    }

    public char getChar(long rowKey) {
        ChunkPage page = this.getChunkPageContaining(rowKey);
        try {
            return page.asCharChunk().get(page.getChunkOffset(rowKey));
        }
        catch (Exception e) {
            throw new TableDataException("Error retrieving char at row key " + rowKey + " from a parquet table", (Throwable)e);
        }
    }
}

