/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionFloat;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import io.deephaven.parquet.table.region.ParquetColumnRegionBase;
import org.jetbrains.annotations.NotNull;

public final class ParquetColumnRegionFloat<ATTR extends Any>
extends ParquetColumnRegionBase<ATTR>
implements ColumnRegionFloat<ATTR>,
ParquetColumnRegion<ATTR> {
    public ParquetColumnRegionFloat(@NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore) {
        super(columnChunkPageStore.mask(), columnChunkPageStore);
    }

    public float getFloat(long rowKey) {
        ChunkPage page = this.getChunkPageContaining(rowKey);
        try {
            return page.asFloatChunk().get(page.getChunkOffset(rowKey));
        }
        catch (Exception e) {
            throw new TableDataException("Error retrieving float at row key " + rowKey + " from a parquet table", (Throwable)e);
        }
    }
}

