/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionLong;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import io.deephaven.parquet.table.region.ParquetColumnRegionBase;
import org.jetbrains.annotations.NotNull;

public final class ParquetColumnRegionLong<ATTR extends Any>
extends ParquetColumnRegionBase<ATTR>
implements ColumnRegionLong<ATTR>,
ParquetColumnRegion<ATTR> {
    public ParquetColumnRegionLong(@NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore) {
        super(columnChunkPageStore.mask(), columnChunkPageStore);
    }

    public long getLong(long rowKey) {
        ChunkPage page = this.getChunkPageContaining(rowKey);
        try {
            return page.asLongChunk().get(page.getChunkOffset(rowKey));
        }
        catch (Exception e) {
            throw new TableDataException("Error retrieving long at row key " + rowKey + " from a parquet table", (Throwable)e);
        }
    }
}

