/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.impl.chunkattributes.DictionaryKeys;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionLong;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionObject;
import io.deephaven.engine.table.impl.sources.regioned.RegionVisitResult;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import io.deephaven.parquet.table.region.ParquetColumnRegionBase;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class ParquetColumnRegionObject<DATA_TYPE, ATTR extends Any>
extends ParquetColumnRegionBase<ATTR>
implements ColumnRegionObject<DATA_TYPE, ATTR>,
ParquetColumnRegion<ATTR> {
    private volatile Supplier<ColumnRegionLong<DictionaryKeys>> dictionaryKeysRegionSupplier;
    private volatile Supplier<ColumnRegionObject<DATA_TYPE, ATTR>> dictionaryValuesRegionSupplier;
    private ColumnRegionLong<DictionaryKeys> dictionaryKeysRegion;
    private ColumnRegionObject<DATA_TYPE, ATTR> dictionaryValuesRegion;

    public ParquetColumnRegionObject(@NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore, @NotNull Supplier<ColumnRegionLong<DictionaryKeys>> dictionaryKeysRegionSupplier, @NotNull Supplier<ColumnRegionObject<DATA_TYPE, ATTR>> dictionaryValuesRegionSupplier) {
        super(columnChunkPageStore.mask(), columnChunkPageStore);
        this.dictionaryKeysRegionSupplier = dictionaryKeysRegionSupplier;
        this.dictionaryValuesRegionSupplier = dictionaryValuesRegionSupplier;
    }

    public DATA_TYPE getObject(long rowKey) {
        ChunkPage page = this.getChunkPageContaining(rowKey);
        try {
            return (DATA_TYPE)page.asObjectChunk().get(page.getChunkOffset(rowKey));
        }
        catch (Exception e) {
            throw new TableDataException("Error retrieving object at Object row key " + rowKey + " from a parquet table", (Throwable)e);
        }
    }

    public RegionVisitResult supportsDictionaryFormat(@NotNull RowSet.SearchIterator keysToVisit) {
        if (!this.columnChunkPageStore.usesDictionaryOnEveryPage()) {
            return RegionVisitResult.FAILED;
        }
        return this.advanceToNextPage(keysToVisit) ? RegionVisitResult.CONTINUE : RegionVisitResult.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnRegionLong<DictionaryKeys> getDictionaryKeysRegion() {
        if (this.dictionaryKeysRegionSupplier != null) {
            ParquetColumnRegionObject parquetColumnRegionObject = this;
            synchronized (parquetColumnRegionObject) {
                if (this.dictionaryKeysRegionSupplier != null) {
                    this.dictionaryKeysRegion = this.dictionaryKeysRegionSupplier.get();
                    this.dictionaryKeysRegionSupplier = null;
                }
            }
        }
        return this.dictionaryKeysRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnRegionObject<DATA_TYPE, ATTR> getDictionaryValuesRegion() {
        if (this.dictionaryValuesRegionSupplier != null) {
            ParquetColumnRegionObject parquetColumnRegionObject = this;
            synchronized (parquetColumnRegionObject) {
                if (this.dictionaryValuesRegionSupplier != null) {
                    this.dictionaryValuesRegion = this.dictionaryValuesRegionSupplier.get();
                    this.dictionaryValuesRegionSupplier = null;
                }
            }
        }
        return this.dictionaryValuesRegion;
    }
}

