/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.region;

import io.deephaven.chunk.attributes.Any;
import io.deephaven.engine.page.ChunkPage;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionShort;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.region.ParquetColumnRegion;
import io.deephaven.parquet.table.region.ParquetColumnRegionBase;
import org.jetbrains.annotations.NotNull;

public final class ParquetColumnRegionShort<ATTR extends Any>
extends ParquetColumnRegionBase<ATTR>
implements ColumnRegionShort<ATTR>,
ParquetColumnRegion<ATTR> {
    public ParquetColumnRegionShort(@NotNull ColumnChunkPageStore<ATTR> columnChunkPageStore) {
        super(columnChunkPageStore.mask(), columnChunkPageStore);
    }

    public short getShort(long rowKey) {
        ChunkPage page = this.getChunkPageContaining(rowKey);
        try {
            return page.asShortChunk().get(page.getChunkOffset(rowKey));
        }
        catch (Exception e) {
            throw new TableDataException("Error retrieving short at row key " + rowKey + " from a parquet table", (Throwable)e);
        }
    }
}

