/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class ArrayAndVectorTransfer<COLUMN_TYPE, ENCODED_COLUMN_TYPE, BUFFER_TYPE>
extends VariableWidthTransfer<COLUMN_TYPE, ENCODED_COLUMN_TYPE, BUFFER_TYPE> {
    final IntBuffer repeatCounts;

    ArrayAndVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetElementsPerPage, int targetPageSizeInBytes, @NotNull BUFFER_TYPE buffer) {
        super(columnSource, tableRowSet, targetElementsPerPage, targetPageSizeInBytes, buffer);
        this.repeatCounts = IntBuffer.allocate(Math.toIntExact(Math.min((long)targetElementsPerPage, tableRowSet.size())));
    }

    @Override
    public final IntBuffer getRepeatCount() {
        return this.repeatCounts;
    }

    @Override
    final boolean addNullToBuffer() {
        if (!this.repeatCounts.hasRemaining()) {
            return false;
        }
        this.repeatCounts.put(Integer.MIN_VALUE);
        return true;
    }

    @Override
    final boolean isBufferEmpty() {
        return this.repeatCounts.position() == 0;
    }

    static final class ArrayDataSupplier<A>
    implements Supplier<A> {
        private A[] data;
        private int pos = 0;

        ArrayDataSupplier() {
        }

        void fill(@NotNull @NotNull A @NotNull [] data) {
            this.data = data;
            this.pos = 0;
        }

        @Override
        public A get() {
            return this.data[this.pos++];
        }
    }
}

