/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.util.BooleanUtils;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

final class BooleanArrayTransfer
extends PrimitiveArrayAndVectorTransfer<Boolean[], Boolean[], ByteBuffer> {
    private static final int BYTES_NEEDED_PER_ENCODED_BOOLEAN_VALUE = 1;
    private static final int NUM_BIT_PACKED_BOOLEANS_PER_BYTE = 8;

    BooleanArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes * 8, targetPageSizeInBytes * 8, ByteBuffer.allocate(targetPageSizeInBytes * 8), 1);
    }

    @Override
    int getSize(Boolean @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = ByteBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<Boolean[]> data) {
        for (Boolean b : (Boolean[])data.encodedValues) {
            ((ByteBuffer)this.buffer).put(BooleanUtils.booleanAsByte((Boolean)b));
        }
    }
}

