/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.FillingPrimitiveTransfer;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

final class BooleanTransfer
extends FillingPrimitiveTransfer<WritableByteChunk<Values>, ByteBuffer> {
    static BooleanTransfer create(@NotNull ColumnSource<?> columnSource, @NotNull RowSet tableRowSet, int targetPageSizeInBytes) {
        int NUM_BIT_PACKED_BOOLEANS_PER_BYTE = 8;
        int targetElementsPerPage = Math.toIntExact(Math.min(tableRowSet.size(), (long)targetPageSizeInBytes * 8L));
        byte[] backingArray = new byte[targetElementsPerPage];
        return new BooleanTransfer(columnSource, (RowSequence)tableRowSet, (WritableByteChunk<Values>)WritableByteChunk.writableChunkWrap((byte[])backingArray), ByteBuffer.wrap(backingArray), targetElementsPerPage);
    }

    private BooleanTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, @NotNull WritableByteChunk<Values> chunk, @NotNull ByteBuffer buffer, int targetElementsPerPage) {
        super(columnSource, tableRowSet, chunk, buffer, targetElementsPerPage);
    }
}

