/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfByte;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.vector.ByteVector;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;

final class ByteVectorTransfer
extends PrimitiveVectorTransfer<ByteVector, IntBuffer> {
    ByteVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, IntBuffer.allocate(targetPageSizeInBytes / 4), 4);
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = IntBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<ByteVector> data) {
        try (CloseablePrimitiveIteratorOfByte dataIterator = ((ByteVector)data.encodedValues).iterator();){
            dataIterator.forEachRemaining(value -> ((IntBuffer)this.buffer).put(value));
        }
    }
}

