/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;

final class CharArrayTransfer
extends PrimitiveArrayAndVectorTransfer<char[], char[], IntBuffer> {
    CharArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, IntBuffer.allocate(targetPageSizeInBytes / 4), 4);
    }

    @Override
    int getSize(char @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = IntBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<char[]> data) {
        for (char value : (char[])data.encodedValues) {
            ((IntBuffer)this.buffer).put(value);
        }
    }
}

