/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.ObjectTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.util.codec.ObjectCodec;
import org.apache.parquet.io.api.Binary;
import org.jetbrains.annotations.NotNull;

final class CodecTransfer<COLUMN_TYPE>
extends ObjectTransfer<COLUMN_TYPE> {
    private final ObjectCodec<? super COLUMN_TYPE> codec;

    CodecTransfer(@NotNull ColumnSource<?> columnSource, @NotNull ObjectCodec<? super COLUMN_TYPE> codec, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes);
        this.codec = codec;
    }

    @Override
    void encodeDataForBuffering(@NotNull COLUMN_TYPE data, @NotNull VariableWidthTransfer.EncodedData<Binary> encodedData) {
        Binary encodedValue = Binary.fromConstantByteArray((byte[])this.codec.encode(data));
        encodedData.fillSingle(encodedValue, encodedValue.length());
    }
}

