/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.time.DateTimeUtils;
import java.nio.IntBuffer;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;

final class DateArrayTransfer
extends PrimitiveArrayAndVectorTransfer<LocalDate[], LocalDate[], IntBuffer> {
    DateArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, IntBuffer.allocate(targetPageSizeInBytes / 4), 4);
    }

    @Override
    int getSize(LocalDate @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = IntBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<LocalDate[]> data) {
        for (LocalDate t : (LocalDate[])data.encodedValues) {
            ((IntBuffer)this.buffer).put(DateTimeUtils.epochDaysAsInt((LocalDate)t));
        }
    }
}

