/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.IntCastablePrimitiveTransfer;
import io.deephaven.time.DateTimeUtils;
import java.nio.IntBuffer;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;

final class DateTransfer
extends IntCastablePrimitiveTransfer<ObjectChunk<LocalDate, Values>> {
    DateTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSet tableRowSet, int targetSize) {
        super(columnSource, (RowSequence)tableRowSet, targetSize);
    }

    @Override
    public void copyAllFromChunkToBuffer() {
        int chunkSize = ((ObjectChunk)this.chunk).size();
        for (int chunkIdx = 0; chunkIdx < chunkSize; ++chunkIdx) {
            ((IntBuffer)this.buffer).put(DateTimeUtils.epochDaysAsInt((LocalDate)((LocalDate)((ObjectChunk)this.chunk).get(chunkIdx))));
        }
    }
}

