/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.vector.ObjectVector;
import java.nio.IntBuffer;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;

final class DateVectorTransfer
extends PrimitiveVectorTransfer<ObjectVector<LocalDate>, IntBuffer> {
    DateVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, IntBuffer.allocate(targetPageSizeInBytes / 4), 4);
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = IntBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<ObjectVector<LocalDate>> data) {
        try (CloseableIterator dataIterator = ((ObjectVector)data.encodedValues).iterator();){
            dataIterator.forEachRemaining(t -> ((IntBuffer)this.buffer).put(DateTimeUtils.epochDaysAsInt((LocalDate)t)));
        }
    }
}

