/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.StringDictionary;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class DictEncodedStringArrayAndVectorTransfer<T>
extends PrimitiveArrayAndVectorTransfer<T, int[], IntBuffer> {
    private final StringDictionary dictionary;
    private boolean pageHasNull;
    private int[] dictEncodedValues;
    private int numDictEncodedValues;

    DictEncodedStringArrayAndVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes, @NotNull StringDictionary dictionary) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, IntBuffer.allocate(targetPageSizeInBytes / 4), 4);
        this.dictionary = dictionary;
        this.pageHasNull = false;
        this.dictEncodedValues = new int[targetPageSizeInBytes];
        this.numDictEncodedValues = 0;
    }

    @Override
    public final int transferOnePageToBuffer() {
        this.pageHasNull = false;
        return super.transferOnePageToBuffer();
    }

    final void encodeDataForBufferingHelper(@NotNull Supplier<String> strSupplier, int numStrings, @NotNull VariableWidthTransfer.EncodedData<int[]> encodedData) {
        this.numDictEncodedValues = 0;
        if (numStrings > this.dictEncodedValues.length) {
            this.dictEncodedValues = new int[numStrings];
        }
        int numBytesEncoded = 0;
        for (int i = 0; i < numStrings; ++i) {
            String value = strSupplier.get();
            if (value == null) {
                this.pageHasNull = true;
            } else {
                numBytesEncoded += 4;
            }
            int posInDictionary = this.dictionary.add(value);
            this.dictEncodedValues[this.numDictEncodedValues++] = posInDictionary;
        }
        encodedData.fillRepeated(this.dictEncodedValues, numBytesEncoded, this.numDictEncodedValues);
    }

    @Override
    final void resizeBuffer(int length) {
        this.buffer = IntBuffer.allocate(length);
    }

    @Override
    final void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<int[]> data) {
        ((IntBuffer)this.buffer).put((int[])data.encodedValues, 0, data.numValues);
    }

    @Override
    public final boolean pageHasNull() {
        return this.pageHasNull;
    }
}

