/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.IntCastablePrimitiveTransfer;
import io.deephaven.parquet.table.transfer.StringDictionary;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;

final class DictEncodedStringTransfer
extends IntCastablePrimitiveTransfer<ObjectChunk<String, Values>> {
    private final StringDictionary dictionary;
    private boolean pageHasNull;

    DictEncodedStringTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes, StringDictionary dictionary) {
        super(columnSource, tableRowSet, targetPageSizeInBytes);
        this.dictionary = dictionary;
        this.pageHasNull = false;
    }

    @Override
    public int transferOnePageToBuffer() {
        this.pageHasNull = false;
        return super.transferOnePageToBuffer();
    }

    @Override
    public void copyAllFromChunkToBuffer() {
        int chunkSize = ((ObjectChunk)this.chunk).size();
        for (int i = 0; i < chunkSize; ++i) {
            String value = (String)((ObjectChunk)this.chunk).get(i);
            if (value == null) {
                this.pageHasNull = true;
            }
            int posInDictionary = this.dictionary.add(value);
            ((IntBuffer)this.buffer).put(posInDictionary);
        }
    }

    @Override
    public boolean pageHasNull() {
        return this.pageHasNull;
    }
}

