/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.DoubleBuffer;
import org.jetbrains.annotations.NotNull;

final class DoubleArrayTransfer
extends PrimitiveArrayAndVectorTransfer<double[], double[], DoubleBuffer> {
    DoubleArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, DoubleBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    int getSize(double @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = DoubleBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<double[]> data) {
        ((DoubleBuffer)this.buffer).put((double[])data.encodedValues);
    }
}

