/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.FillingPrimitiveTransfer;
import java.nio.DoubleBuffer;
import org.jetbrains.annotations.NotNull;

final class DoubleTransfer
extends FillingPrimitiveTransfer<WritableDoubleChunk<Values>, DoubleBuffer> {
    static DoubleTransfer create(@NotNull ColumnSource<?> columnSource, @NotNull RowSet tableRowSet, int targetPageSizeInBytes) {
        int targetElementsPerPage = Math.toIntExact(Math.min(tableRowSet.size(), (long)(targetPageSizeInBytes / 8)));
        double[] backingArray = new double[targetElementsPerPage];
        return new DoubleTransfer(columnSource, (RowSequence)tableRowSet, (WritableDoubleChunk<Values>)WritableDoubleChunk.writableChunkWrap((double[])backingArray), DoubleBuffer.wrap(backingArray), targetElementsPerPage);
    }

    private DoubleTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, @NotNull WritableDoubleChunk<Values> chunk, @NotNull DoubleBuffer buffer, int targetElementsPerPage) {
        super(columnSource, tableRowSet, chunk, buffer, targetElementsPerPage);
    }
}

