/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfDouble;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.vector.DoubleVector;
import java.nio.DoubleBuffer;
import org.jetbrains.annotations.NotNull;

final class DoubleVectorTransfer
extends PrimitiveVectorTransfer<DoubleVector, DoubleBuffer> {
    DoubleVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 8, targetPageSizeInBytes, DoubleBuffer.allocate(targetPageSizeInBytes / 8), 8);
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = DoubleBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<DoubleVector> data) {
        try (CloseablePrimitiveIteratorOfDouble dataIterator = ((DoubleVector)data.encodedValues).iterator();){
            dataIterator.forEachRemaining(value -> ((DoubleBuffer)this.buffer).put(value));
        }
    }
}

