/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.TransferObject;
import java.nio.Buffer;
import org.jetbrains.annotations.NotNull;

abstract class FillingPrimitiveTransfer<CHUNK_TYPE extends WritableChunk<Values>, BUFFER_TYPE extends Buffer>
implements TransferObject<BUFFER_TYPE> {
    private final CHUNK_TYPE chunk;
    private final BUFFER_TYPE buffer;
    private final ColumnSource<?> columnSource;
    private final RowSequence.Iterator tableRowSetIt;
    private final ChunkSource.FillContext context;
    private final int targetElementsPerPage;

    <A> FillingPrimitiveTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, @NotNull CHUNK_TYPE chunk, @NotNull BUFFER_TYPE buffer, int targetElementsPerPage) {
        this.columnSource = columnSource;
        this.tableRowSetIt = tableRowSet.getRowSequenceIterator();
        this.chunk = chunk;
        this.buffer = buffer;
        Assert.gtZero((int)targetElementsPerPage, (String)"targetElementsPerPage");
        this.targetElementsPerPage = targetElementsPerPage;
        this.context = columnSource.makeFillContext(targetElementsPerPage);
    }

    @Override
    public final int transferOnePageToBuffer() {
        if (!this.hasMoreDataToBuffer()) {
            return 0;
        }
        RowSequence rs = this.tableRowSetIt.getNextRowSequenceWithLength((long)this.targetElementsPerPage);
        this.columnSource.fillChunk(this.context, this.chunk, rs);
        ((Buffer)this.buffer).position(0);
        ((Buffer)this.buffer).limit(this.chunk.size());
        return this.chunk.size();
    }

    @Override
    public final boolean hasMoreDataToBuffer() {
        return this.tableRowSetIt.hasMore();
    }

    @Override
    public final BUFFER_TYPE getBuffer() {
        return this.buffer;
    }

    public final void close() {
        this.context.close();
        this.tableRowSetIt.close();
    }
}

