/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import java.nio.FloatBuffer;
import org.jetbrains.annotations.NotNull;

final class FloatArrayTransfer
extends PrimitiveArrayAndVectorTransfer<float[], float[], FloatBuffer> {
    FloatArrayTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, FloatBuffer.allocate(targetPageSizeInBytes / 4), 4);
    }

    @Override
    int getSize(float @NotNull [] data) {
        return data.length;
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = FloatBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<float[]> data) {
        ((FloatBuffer)this.buffer).put((float[])data.encodedValues);
    }
}

