/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.FillingPrimitiveTransfer;
import java.nio.FloatBuffer;
import org.jetbrains.annotations.NotNull;

final class FloatTransfer
extends FillingPrimitiveTransfer<WritableFloatChunk<Values>, FloatBuffer> {
    static FloatTransfer create(@NotNull ColumnSource<?> columnSource, @NotNull RowSet tableRowSet, int targetPageSizeInBytes) {
        int targetElementsPerPage = Math.toIntExact(Math.min(tableRowSet.size(), (long)(targetPageSizeInBytes / 4)));
        float[] backingArray = new float[targetElementsPerPage];
        return new FloatTransfer(columnSource, (RowSequence)tableRowSet, (WritableFloatChunk<Values>)WritableFloatChunk.writableChunkWrap((float[])backingArray), FloatBuffer.wrap(backingArray), targetElementsPerPage);
    }

    private FloatTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, @NotNull WritableFloatChunk<Values> chunk, @NotNull FloatBuffer buffer, int targetElementsPerPage) {
        super(columnSource, tableRowSet, chunk, buffer, targetElementsPerPage);
    }
}

