/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfFloat;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.PrimitiveVectorTransfer;
import io.deephaven.parquet.table.transfer.VariableWidthTransfer;
import io.deephaven.vector.FloatVector;
import java.nio.FloatBuffer;
import org.jetbrains.annotations.NotNull;

final class FloatVectorTransfer
extends PrimitiveVectorTransfer<FloatVector, FloatBuffer> {
    FloatVectorTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, int targetPageSizeInBytes) {
        super(columnSource, tableRowSet, targetPageSizeInBytes / 4, targetPageSizeInBytes, FloatBuffer.allocate(targetPageSizeInBytes / 4), 4);
    }

    @Override
    void resizeBuffer(int length) {
        this.buffer = FloatBuffer.allocate(length);
    }

    @Override
    void copyToBuffer(@NotNull VariableWidthTransfer.EncodedData<FloatVector> data) {
        try (CloseablePrimitiveIteratorOfFloat dataIterator = ((FloatVector)data.encodedValues).iterator();){
            dataIterator.forEachRemaining(value -> ((FloatBuffer)this.buffer).put(value));
        }
    }
}

