/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.ChunkBase;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.TransferObject;
import java.nio.Buffer;
import org.jetbrains.annotations.NotNull;

abstract class GettingPrimitiveTransfer<CHUNK_TYPE extends ChunkBase<Values>, BUFFER_TYPE extends Buffer>
implements TransferObject<BUFFER_TYPE> {
    protected CHUNK_TYPE chunk;
    protected final BUFFER_TYPE buffer;
    private final ColumnSource<?> columnSource;
    private final RowSequence.Iterator tableRowSetIt;
    private final ChunkSource.GetContext context;
    private final int targetElementsPerPage;

    GettingPrimitiveTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, BUFFER_TYPE buffer, int targetElementsPerPage) {
        this.columnSource = columnSource;
        this.tableRowSetIt = tableRowSet.getRowSequenceIterator();
        this.buffer = buffer;
        Assert.gtZero((int)targetElementsPerPage, (String)"targetElementsPerPage");
        this.targetElementsPerPage = targetElementsPerPage;
        this.context = columnSource.makeGetContext(targetElementsPerPage);
    }

    @Override
    public int transferOnePageToBuffer() {
        if (!this.hasMoreDataToBuffer()) {
            return 0;
        }
        ((Buffer)this.buffer).clear();
        RowSequence rs = this.tableRowSetIt.getNextRowSequenceWithLength((long)this.targetElementsPerPage);
        this.chunk = (ChunkBase)this.columnSource.getChunk(this.context, rs);
        this.copyAllFromChunkToBuffer();
        ((Buffer)this.buffer).flip();
        int ret = this.chunk.size();
        this.chunk = null;
        return ret;
    }

    abstract void copyAllFromChunkToBuffer();

    @Override
    public final boolean hasMoreDataToBuffer() {
        return this.tableRowSetIt.hasMore();
    }

    @Override
    public final BUFFER_TYPE getBuffer() {
        return this.buffer;
    }

    public final void close() {
        this.context.close();
        this.tableRowSetIt.close();
    }
}

