/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.transfer;

import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.parquet.table.transfer.FillingPrimitiveTransfer;
import java.nio.IntBuffer;
import org.jetbrains.annotations.NotNull;

final class IntTransfer
extends FillingPrimitiveTransfer<WritableIntChunk<Values>, IntBuffer> {
    static IntTransfer create(@NotNull ColumnSource<?> columnSource, @NotNull RowSet tableRowSet, int targetPageSizeInBytes) {
        int targetElementsPerPage = Math.toIntExact(Math.min(tableRowSet.size(), (long)(targetPageSizeInBytes / 4)));
        int[] backingArray = new int[targetElementsPerPage];
        return new IntTransfer(columnSource, (RowSequence)tableRowSet, (WritableIntChunk<Values>)WritableIntChunk.writableChunkWrap((int[])backingArray), IntBuffer.wrap(backingArray), targetElementsPerPage);
    }

    private IntTransfer(@NotNull ColumnSource<?> columnSource, @NotNull RowSequence tableRowSet, @NotNull WritableIntChunk<Values> chunk, @NotNull IntBuffer buffer, int targetElementsPerPage) {
        super(columnSource, tableRowSet, chunk, buffer, targetElementsPerPage);
    }
}

